<?php
include_once './simple_html_dom.php';

class App
{
  public $host;
  public $username;
  public $password;

  public function __construct($host, $username, $password)
  {
    $this->host = $host;
    $this->username = $username;
    $this->password = $password;
  }

  // init cookie
  public function init()
  {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $this->host);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($ch, CURLOPT_COOKIEJAR, "./cookie.txt");
    curl_setopt($ch, CURLOPT_COOKIEFILE, "./cookie.txt");
    curl_setopt($ch, CURLOPT_HEADER, 1);
    $result = curl_exec($ch);
    curl_close($ch);

    // login status
    return !preg_match("/Enter your username/", $result) ? true : false;
  }


  // login to account
  public function login()
  {
    $form = "user={$this->username}&pass={$this->password}&goto_uri=%2F";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "{$this->host}/login/?login_only=1");
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $form);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($ch, CURLOPT_COOKIEJAR, "./cookie.txt");
    curl_setopt($ch, CURLOPT_COOKIEFILE, "./cookie.txt");
    curl_setopt($ch, CURLOPT_HEADER, 0);
    $result = curl_exec($ch);

    curl_close($ch);

    $json = json_decode($result);

    if ($json->status == 1) {
      $file = fopen('./token.txt', 'r+');
      fwrite($file,  $json->security_token);
      fclose($file);

      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, "{$this->host}{$json->redirect}");
      curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
      curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
      curl_setopt($ch, CURLOPT_COOKIEJAR, "./cookie.txt");
      curl_setopt($ch, CURLOPT_COOKIEFILE, "./cookie.txt");
      $result = curl_exec($ch);
      curl_close($ch);

      return true;
    }

    return false;
  }

  // open dashboard
  public function dashboard()
  {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "{$this->host}{$this->_token()}");
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($ch, CURLOPT_COOKIEJAR, "./cookie.txt");
    curl_setopt($ch, CURLOPT_COOKIEFILE, "./cookie.txt");
    $result = curl_exec($ch);
    curl_close($ch);

    // login status
    return preg_match("/Log Out/", $result) ? true : false;
  }

  // create new cpanel user
  public function wwwacct($domain)
  {
    $data = [
      'ok' => true,
      'msg' => '',
    ];

    $username = $this->_randomString(8, 'abcdefghijklmnopqrstuvwxyz');
    $password = $this->_randomString();

    $form = [
      'sign' => '',
      'plan' => 'cPanel Super',
      'domain' => $domain,
      'username' => $username,
      'password' => $password,
      'contactemail' => '',
      'dbuser' => $username,
      'msel' => 'n,y,1000,,paper_lantern,unlimited,unlimited,unlimited,unlimited,unlimited,4000,n,0,0,default,en,unlimited,unlimited,,n,unlimited,cPanel Super',
      'pkgname' => '',
      'featurelist' => 'default',
      'quota' => '1000',
      'bwlimit' => '4000',
      'maxftp' => 'unlimited',
      'maxpop' => 'unlimited',
      'maxlst' => 'unlimited',
      'maxsql' => 'unlimited',
      'maxsub' => 'unlimited',
      'maxpark' => 0,
      'maxaddon' => 0,
      'maxpassengerapps' => 0,
      'maxpassengerapps_control' => 'unlimited',
      'max_email_per_hour' => 'unlimited',
      'max_defer_fail_percentage' => 'unlimited',
      'max_emailacct_quota' => 'unlimited',
      'cgi' => 1,
      'cpmod' => 'paper_lantern',
      'language' => 'en',
      'spamassassin' => 1,
      'spambox' => 1,
      'mxcheck' => 'local',
      'hasuseregns' => 1,
      'dkim' => 1,
      'spf' => 1,
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "{$this->host}{$this->_token()}/scripts5/wwwacct");
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($form));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($ch, CURLOPT_COOKIEJAR, "./cookie.txt");
    curl_setopt($ch, CURLOPT_COOKIEFILE, "./cookie.txt");
    $result = curl_exec($ch);
    curl_close($ch);

    // validate request
    if (preg_match("/Account Creation Status: ok/", $result)) {
      $account_result = "+===================================+";
      $explode_result = explode($account_result, $result);

      $account_result .= $explode_result[1];
      $account_result .= "+===================================+";
      $account_result .= $explode_result[2];
      $account_result .= "+===================================+";

      $data['msg'] = 'Akun berhasil dibuat';
      $data['data'] = $account_result;
    } else {
      $dom = str_get_html($result);

      $data['ok'] = false;
      $data['msg'] = $dom->find('td', 0)->innertext ?? 'Terjadi kesalahan saat membuat akun';
    }

    return $data;
  }

  // get create user form
  public function wwwacctform()
  {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "{$this->host}{$this->_token()}/scripts5/wwwacctform");
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($ch, CURLOPT_COOKIEJAR, "./cookie.txt");
    curl_setopt($ch, CURLOPT_COOKIEFILE, "./cookie.txt");
    $result = curl_exec($ch);
    curl_close($ch);

    // todo: -
    // return preg_match("/foo/", $result) ? true : false;
    return $result;
  }

  // get token from local
  private function _token()
  {
    $file = fopen('./token.txt', 'r');
    $token = fread($file, filesize('./token.txt') ?? 1);
    fclose($file);

    return $token;
  }

  // generate random string
  private function _randomString($length = 8, $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz')
  {
    $str = "";
    $chars = str_split($chars);
    for ($i = 0; $i < $length; $i++) $str .= $chars[array_rand($chars)];

    return $str . rand(0, 99);
  }
}
