const notyf = new Notyf();

const app = () => {
  return {
    warning: '',
    success: '',
    loading: false,
    results: [],
    async formSubmit() {
      this.loading = true;
      [this.warning, this.success] = ['', ''];
      const form = Object.fromEntries(new FormData(this.$event.target));
      const domains = form.domains.trim().split("\n").filter(el => el != '').map(el => el.trim());

      if (!(domains.length > 0)) {
        this.warning = "Form masih kosong";
        this.loading = false;
        return;
      }

      this.results = await Promise.all(domains.map(async function (domain) {
        let data = {};
        try {
          const body = (new FormData());
          body.append('domain', domain);

          const request = await redaxios.post('./api.php?action=add_cpanel', body);
          data = { ...request.data, domain };
        } catch (error) {
          data = { ok: false, msg: 'Kesalahan tidak diketahui', domain }
        }

        return data;
      }));

      this.loading = false;
    },
    copyCpanelInfo(index) {
      if (copee.toClipboard(this.results[index].data)) notyf.success("Data akun berhasil disalin");
      else notyf.error("Data akun gagal disalin");
    },
    copyCpanelInfoAll() {
      let results = '';

      this.results.map(el => el.ok ? (results += `${el.data}\n\n\n`) : '');

      if (copee.toClipboard(results)) notyf.success("Data akun berhasil disalin");
      else notyf.error("Data akun gagal disalin");
    }
  }
}